<?php
/* --------------------------------------------------------------
   TrackingCodeSqlPagination.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\SqlCriteria;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeSqlPagination as TrackingCodeSqlPaginationInterface;
use Gambio\Core\Criteria\AbstractSqlPagination;
use Webmozart\Assert\Assert;

/**
 * Class TrackingCodeSqlPagination
 *
 * @package Gambio\Admin\TrackingCode\SqlCriteria
 */
class TrackingCodeSqlPagination extends AbstractSqlPagination implements TrackingCodeSqlPaginationInterface
{
    /**
     * TrackingCodeSqlPagination constructor.
     *
     * @param int|null $limit
     * @param int|null $offset
     */
    private function __construct(?int $limit = null, ?int $offset = null)
    {
        $this->limit  = $limit;
        $this->offset = $offset;
    }
    
    
    /**
     * @param int $limit
     * @param int $offset
     *
     * @return TrackingCodeSqlPagination
     */
    public static function create(int $limit = 25, int $offset = 0): TrackingCodeSqlPagination
    {
        Assert::greaterThan($limit, 0, 'Limit needs to be greater than 0. Got: %s');
        Assert::greaterThanEq($offset, 0, 'Offset needs to be greater or equals 0. Got: %s');
        
        return new self($limit, $offset);
    }
    
    
    /**
     * @param int $limit
     *
     * @return TrackingCodeSqlPagination
     */
    public static function createWithoutOffset(int $limit = 25): TrackingCodeSqlPagination
    {
        Assert::greaterThan($limit, 0, 'Limit needs to be greater than 0. Got: %s');
        
        return new self($limit);
    }
    
    
    /**
     * @param int $offset
     *
     * @return TrackingCodeSqlPagination
     */
    public static function createWithoutLimit(int $offset = 0): TrackingCodeSqlPagination
    {
        Assert::greaterThanEq($offset, 0, 'Offset needs to be greater or equals 0. Got: %s');
        
        return new self(null, $offset);
    }
}